scriptname _SLSubmitTargetSelect extends ReferenceAlias
;This is a modified SexLab MatchMaker Script

int version = 3

SexLabFramework property SexLab auto
GlobalVariable Property _SLSubmitFriendlyGlobal  Auto
GlobalVariable Property _SLSubmitFollowerGlobal  Auto
GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitFSurrenderGlobal  Auto
Actor Property PlayerRef Auto

_SLSubmitConfig Property _SLConfig auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene auto

ReferenceAlias[] property ActorList auto
ReferenceAlias property ActorSelection00 auto
ReferenceAlias property ActorSelection01 auto
ReferenceAlias property ActorSelection02 auto

Event OnPlayerLoadGame()
	_SLQuest.deactivateMod()
	_SLQuest.activateMod()
EndEvent

event OnInit()
	ActorList = new ReferenceAlias[3]
	ActorList[0] = ActorSelection00
	ActorList[1] = ActorSelection01
	ActorList[2] = ActorSelection02
endEvent

int function RegisterActor(actor a)
	if ActorList[0].GetActorRef() == a || ActorList[1].GetActorRef() == a || ActorList[2].GetActorRef() == a
		return -1
	endIf

	int i = 0
	while i < 3
		if ActorList[i].ForceRefIfEmpty(a) ; Slot them into a storage spot
			return i
		endIf
		i += 1
	endWhile

	;debug.Notification("Your spell fizzles and fails to captivate anybody else")
	return -1
endFunction

function UnregisterActor(int slot)
	if slot >= 0
		ActorList[slot].Clear()
	endIf
endFunction

function CheckActors()
	actor[] sexActors
	int i = 0
	while i < 3
		actor a = ActorList[i].GetActorRef()
		if a != none
			sexActors = sslUtility.PushActor(a, sexActors)
			ActorList[i].Clear()
		endIf
		i += 1
	endWhile
	If (_SLSubmitFollowerGlobal.GetValue() == 2)
		If sexActors.Length >= 2
			_SLSubmitFollowerGlobal.SetValue(0)
			RegisterForModEvent("AnimationEnd_MatchMaker", "EndMessage")
			_SLScene.FollowerSex(sexActors)
		EndIf
	EndIf	
	If (_SLSubmitSurrenderGlobal.GetValue() == 1)
		If sexActors.Length >= 2
			_SLSubmitSurrenderGlobal.SetValue(2)
			RegisterForModEvent("AnimationEnd_MatchMaker", "EndMessage")
			_SLScene.PlayerSex(sexActors)
		Else
			_SLSubmitSurrenderGlobal.SetValue(0)
		EndIf
	EndIf
	If (_SLSubmitFriendlyGlobal.GetValue() == 1)
		If sexActors.Length >= 2
			_SLSubmitFriendlyGlobal.SetValue(0)
			RegisterForModEvent("AnimationEnd_MatchMaker", "EndMessage")
			If PlayerRef.IsWeaponDrawn()
				PlayerRef.SheatheWeapon()	
				_SLScene.WRT(2.0)
			EndIf
			actor Victim = sexActors[0]
			actor Follower = sexActors[1]
			actor Player = sexActors[2]
			_SLScene.WRT(0.5)
			If (!PlayerRef.IsInCombat())
				If(_SLConfig.VictimActive)
					sexActors = SexLab.SortActors(sexActors, femaleFirst=true)
				EndIf
				if sexActors.Length == 3
					Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
					sslBaseAnimation[] anims = SexLab.GetAnimationsByType(3)	
					_SLScene.RegisterForModEvent("AnimationEnd_PostCoitalBliss", "PostCoitalBliss")
					SexLab.StartSex(sexActors, anims, hook="PostCoitalBliss")
				elseif sexActors.Length == 2
					Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
					sslBaseAnimation[] anims = SexLab.GetAnimationsByType(2)
					_SLScene.RegisterForModEvent("AnimationEnd_PostCoitalBliss", "PostCoitalBliss")
					SexLab.StartSex(sexActors, anims, hook="PostCoitalBliss")
				endif
			EndIf
		EndIf
	EndIf
endFunction

event EndMessage(string eventName, string argString, float argNum, form sender)
	actor[] sexActors = SexLab.HookActors(argString)
	int i = 0
	while i < sexActors.Length
		i += 1
	endWhile
endEvent